    /*
 * File:   main_header.h
 * Stand Alone Flyback MCP19114/MCP19115
 *
 * Created on May 15, 2013, 5:54 PM
 */

#ifndef MAIN_HEADER_H
#define	MAIN_HEADER_H

#define SIG_COUNT_VAR 20
#define OV10V 33

//----- Function Prototypes --------//
extern void init_Calibration(void);
extern void init_SFR(void);
extern void init_Periphrials(void);
extern void IIC_Handler(void);
extern void Update_Controller(void);
extern void FLASH_1(void);
extern void FLASH_2(void);
extern void FLASH_3(void);
extern void FLASH_4(void);

// ------ Variables ---------//
int COUNT;              //  Flashing Counts
int OVF;                //  Over Voltage indicator
unsigned char A2GAIN;   //  A2GAIN correction
unsigned long ADCC;     //  ADC Correction
signed char BUOFFSET;   //  Buffer offset Correction

//---------------------------------//
// Variables that are changed by I2C (ADDRESSES MUST REMAIN THE SAME)//
volatile unsigned char SSP_ENABLE         @   0x020;
volatile unsigned char SSP_PR2            @   0x021;
volatile unsigned char SSP_PWMR           @   0x022;
volatile unsigned char SSP_VREFCON1       @   0x023;
volatile unsigned char SSP_DEADCON        @   0x024;
volatile unsigned char SSP_VINUVLO        @   0x025;
volatile unsigned char SSP_VINOVLO        @   0x026;
volatile unsigned char SSP_OVREFCON       @   0x027;
volatile unsigned char SSP_ABECON         @   0x028;
volatile unsigned char SSP_ADCON0         @   0x029;
volatile unsigned char SSP_REG_ADD0       @   0x02A;
volatile unsigned char SSP_REG_ADD1       @   0x02B;
volatile unsigned char SSP_REG_ADD2       @   0x02C;
volatile unsigned char SSP_REG_ADD3       @   0x02D;
volatile unsigned char SSP_REG_DATA0      @   0x02E;
volatile unsigned char SSP_REG_DATA1      @   0x02F;

volatile unsigned char SSP_REG_DATA2      @   0x030;
volatile unsigned char SSP_REG_DATA3      @   0x031;
volatile unsigned char SSP_ICLEBCON       @   0x032;
volatile unsigned char SSP_ICOACON        @   0x033;
volatile unsigned char SSP_SLPCRCON       @   0x034;
volatile unsigned char SSP_REG_BANK       @   0x035;
volatile unsigned char SSP_UPDATE         @   0x036;

typedef union {
    struct {
        unsigned VINOVLO_EN              :1;
        unsigned VINUVLO_EN              :1;
        unsigned FF_QRn                  :1;
        unsigned SYNC_ASYNCn             :1;
        unsigned VOUOVLO_EN              :1;
        unsigned EN                      :1;
        unsigned                         :1;
        unsigned                         :1;
    };
} SSP_ENABLEbits_t;
volatile SSP_ENABLEbits_t SSP_ENABLEbits @ 0x020;
// bitfield macros
#define _SSP_ENABLE_VINOVLO_EN_POSN         0x0
#define _SSP_ENABLE_VINOVLO_EN_POSITION     0x0
#define _SSP_ENABLE_VINOVLO_EN_SIZE         0x1
#define _SSP_ENABLE_VINOVLO_EN_LENGTH       0x1
#define _SSP_ENABLE_VINOVLO_EN_MASK         0x1
#define _SSP_ENABLE_VINUVLO_EN_POSN         0x1
#define _SSP_ENABLE_VINUVLO_EN_POSITION     0x1
#define _SSP_ENABLE_VINUVLO_EN_SIZE         0x1
#define _SSP_ENABLE_VINUVLO_EN_LENGTH       0x1
#define _SSP_ENABLE_VINUVLO_EN_MASK         0x2
#define _SSP_ENABLE_FF_QRn_POSN             0x2
#define _SSP_ENABLE_FF_QRn_POSITION         0x2
#define _SSP_ENABLE_FF_QRn_SIZE             0x1
#define _SSP_ENABLE_FF_QRn_LENGTH           0x1
#define _SSP_ENABLE_FF_QRn__MASK            0x4
#define _SSP_ENABLE_SYNC_ASYNCn_POSN        0x3
#define _SSP_ENABLE_SYNC_ASYNCn_POSITION    0x3
#define _SSP_ENABLE_SYNC_ASYNCn_SIZE        0x1
#define _SSP_ENABLE_SYNC_ASYNCn_LENGTH      0x1
#define _SSP_ENABLE_SYNC_ASYNCn_MASK        0x8
#define _SSP_ENABLE_VOUOVLO_EN_POSN         0x4
#define _SSP_ENABLE_VOUOVLO_EN_POSITION     0x4
#define _SSP_ENABLE_VOUOVLO_EN_SIZE         0x1
#define _SSP_ENABLE_VOUOVLO_EN_LENGTH       0x1
#define _SSP_ENABLE_VOUOVLO_EN_MASK         0x10
#define _SSP_ENABLE_EN_POSN                 0x5
#define _SSP_ENABLE_EN_POSITION             0x5
#define _SSP_ENABLE_EN_SIZE                 0x1
#define _SSP_ENABLE_EN_LENGTH               0x1
#define _SSP_ENABLE_EN_MASK                 0x20

typedef union {
    struct {
        unsigned BANK0_EN                :1;
        unsigned BANK1_EN                :1;
        unsigned BANK2_EN                :1;
        unsigned BANK3_EN                :1;
        unsigned SWITCH_1                :1;
        unsigned SWITCH_2                :1;
        unsigned                         :1;
        unsigned                         :1;
    };
} SSP_REG_BANKbits_t;
volatile SSP_REG_BANKbits_t SSP_REG_BANKbits @ 0x035;
// bitfield macros
#define _SSP_REG_BANK_BANK0_EN_POSN                      0x0
#define _SSP_REG_BANK_BANK0_EN_POSITION                  0x0
#define _SSP_REG_BANK_BANK0_EN_SIZE                      0x1
#define _SSP_REG_BANK_BANK0_EN_LENGTH                    0x1
#define _SSP_REG_BANK_BANK0_EN_MASK                      0x1
#define _SSP_REG_BANK_BNAK1_EN_POSN                      0x1
#define _SSP_REG_BANK_BNAK1_EN_POSITION                  0x1
#define _SSP_REG_BANK_BNAK1_EN_SIZE                      0x1
#define _SSP_REG_BANK_BNAK1_EN_LENGTH                    0x1
#define _SSP_REG_BANK_BNAK1_EN_MASK                      0x2
#define _SSP_REG_BANK_BANK2_EN_POSN                      0x2
#define _SSP_REG_BANK_BANK2_EN_POSITION                  0x2
#define _SSP_REG_BANK_BANK2_EN_SIZE                      0x1
#define _SSP_REG_BANK_BANK2_EN_LENGTH                    0x1
#define _SSP_REG_BANK_BANK2_EN__MASK                     0x4
#define _SSP_REG_BANK_BANK3_EN_POSN                      0x3
#define _SSP_REG_BANK_BANK3_EN_POSITION                  0x3
#define _SSP_REG_BANK_BANK3_EN_SIZE                      0x1
#define _SSP_REG_BANK_BANK3_EN_LENGTH                    0x1
#define _SSP_REG_BANK_BANK3_EN_MASK                      0x8
#define _SSP_REG_BANK_SWITCH_1_POSN                      0x4
#define _SSP_REG_BANK_SWITCH_1_POSITION                  0x4
#define _SSP_REG_BANK_SWITCH_1_SIZE                      0x1
#define _SSP_REG_BANK_SWITCH_1_LENGTH                    0x1
#define _SSP_REG_BANK_SWITCH_1_MASK                      0x10
#define _SSP_REG_BANK_SWITCH_2_POSN                      0x5
#define _SSP_REG_BANK_SWITCH_2_POSITION                  0x5
#define _SSP_REG_BANK_SWITCH_2_SIZE                      0x1
#define _SSP_REG_BANK_SWITCH_2_LENGTH                    0x1
#define _SSP_REG_BANK_SWITCH_2_MASK                      0x20

// Operating States
//#define LIGHTS_OFF  0
//#define LB_ON       1
//#define DRL_ON      1
//#define HB_ON       2
//#define SIG_ON      2
//#define DRL_SIG_ON  3
//#define BLINK       4

// Dimming State
//#define STATE0      0
//#define STATE1      1
//#define STATE2      2
//#define STATE3      3

// Blinking Time
//#define BLINK_STATE0    4
//#define BLINK_STATE1    4
//#define BLINK_STATE2    24
//#define BLINK_STATE3    4

// Driver States
#define PDRV_ON         0x80
#define SDRV_ON         0x40
#define PDRV_SDRV_ON    0xC0
#define PDRV_SDRV_OFF   0x00
#define STR_PDRV        0x82    // Open loop reposition output voltage up
#define STR_SDRV        0x41    // Open loop reposition output voltage down

// Reposition PWM
#define REPO_PWM    0x27    // Open loop reposition 200kHz
#define REPO_SS_PWM 0x27    // Open loop reposition 200kHz
#define REPO_DC     0x10    // Open loop reposition duty cycle 40%
#define REPO_SS_DC  0x0A    // Open loop soft-start duty cycle 25%
//#define DIM_DC      0x06    // Open loop dim hold duty cycle 15%
//
//// Reposition voltage levels
//#define REPO_LB     80    // Open loop reposition down voltage = 20V
//#define REPO_HB     152   // Open loop reposition up voltage = 38V
//#define REPO_SS_LB  72    // Open loop reposition soft-start voltage = 18V
//#define REPO_SS_HB  144   // Open loop reposition soft-start voltage = 38V
//#define REPO_DRL    108   // Open loop reposition up voltage = 25V
//#define REPO_SIG    56    // Open loop reposition down voltage = 12V
//#define REPO_SS_DRL 100   // Open loop reposition soft-start voltage = 25V
//#define REPO_SS_SIG 48    // Open loop reposition soft-start voltage = 12V

// Desaturation comparator control
#define DESATCON_QR 0x68
#define DESATCON_FF 0

#define CMD_NO_CURRENT 0

// Timer 0 period
#define PS256uS     0
#define PS512uS     1
#define PS1024uS    2
#define PS2048uS    3
//#define PS4096uS    4
//#define PS8192uS    5
//#define PS16384uS   6
//#define PS32768uS   7

#endif	/* MAIN_HEADER_H */

